%%
%% This is file `uealttr.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% uealttr.dtx  (with options: `class')
%% ----------------------------------------------------------------
%% The uealttr package --- A letter class for the University of
%%   East Anglia (UEA)
%% Maintained by Joseph Wright
%% E-mail: joseph.wright@uea.ac.uk
%% Released under the LaTeX Project Public License v1.3c or later
%% See http://www.latex-project.org/lppl.txt
%% ----------------------------------------------------------------
%% 
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{uealttr}
  [2010/12/23 v1.2 A letter class for UEA]
\LoadClass[10pt,a4paper]{letter}
\RequirePackage[T1]{fontenc}
\RequirePackage[final]{graphicx}
\RequirePackage[parfill]{parskip}
\RequirePackage{helvet,eso-pic,ifpdf,kvoptions}
\RequirePackage[hmargin=30mm,vmargin=25mm]{geometry}
\SetupKeyvalOptions{
  family = uea,
  prefix = uea@}
\DeclareBoolOption{personal}
\DeclareBoolOption{confidential}
\DeclareBoolOption{logo}
\DeclareBoolOption{draft}
\DeclareComplementaryOption{final}{draft}
\setkeys{uea}{
  personal = false,
  confidential = false,
  logo = true,
  draft = false}
\ProcessKeyvalOptions{uea}
\ifuea@draft
  \setlength\overfullrule{5pt}
\else
  \setlength\overfullrule{0pt}
\fi
\newcommand*{\uea@pandc}{}
\ifuea@personal
  \renewcommand*{\uea@pandc}{PERSONAL}
  \ifuea@confidential
    \renewcommand*{\uea@pandc}{PERSONAL \& CONFIDENTIAL}
  \fi
\else
  \ifuea@confidential
    \renewcommand*{\uea@pandc}{CONFIDENTIAL}
  \fi
\fi
\renewcommand\familydefault{\sfdefault}
\newcommand*\subject[1]{\def\lettersubject{#1}}
\subject{}
\newcommand*\faculty[1]{\def\fromfaculty{#1}}
\newcommand*\school[1]{\def\fromschool{#1}}
\let\department\school
\faculty{}
\school{}
\newcommand*\email[1]{\def\fromemail{#1}}
\let\phone\telephone
\newcommand*\fax[1]{\def\fromfax{#1}}
\newcommand*\web[1]{\def\fromweb{#1}}
\email{}
\telephone{}
\fax{}
\web{}
\newcommand*\position[1]{\def\fromposition{#1}}
\newcommand*\signphone[1]{\def\fromsignphone{#1}}
\newcommand*\signemail[1]{\def\fromsignemail{#1}}
\position{}
\signphone{}
\signemail{}
\newcommand*\sigfile[1]{\def\fromsigfile{#1}}
\sigfile{}
\newcommand*\logo[1]{\def\fromlogo{#1}}
\logo{uealogo}
\InputIfFileExists{uealttr.cfg}
  {\ClassInfo{uealttr}{Loaded local configuration file}}
  {}
\ifpdf
  \IfFileExists{\fromlogo.pdf}
    {}
    {\ifuea@logo
       \ClassWarning{uealttr}
         {Logo file \fromlogo.pdf not found!\MessageBreak
          No logo will be included in output}
     \fi
     \uea@logofalse}
\else
  \IfFileExists{\fromlogo.eps}
    {}
    {\ifuea@logo
       \ClassWarning{uealttr}
         {Logo file \fromlogo.eps not found!\MessageBreak
          No logo will be included in output}
     \fi
     \uea@logofalse}
\fi
\newenvironment{wider}{%
  \begin{list}{}{%
    \setlength{\topsep}{0pt}%
    \setlength{\leftmargin}{\z@}%
    \setlength{\rightmargin}{-22mm}%
    \setlength{\listparindent}{\parindent}%
    \setlength{\itemindent}{\parindent}%
    \setlength{\parsep}{\parskip}%
  }%
  \item[]}{\end{list}}

\renewcommand*\opening[1]{%
  \thispagestyle{empty}%
  \vspace*{18mm}%
  \ifuea@logo
    \AddToShipoutPicture*{%
      \setlength{\unitlength}{1mm}%
      \put(149,257.5){\includegraphics[scale=0.95]{\fromlogo}}}%
  \fi
  \begin{wider}
    \setlength{\leftmargin}{\z@}%
    \setlength{\rightmargin}{22mm}%
    \begin{minipage}[t]{80mm}
      \begin{minipage}[t]{80mm}
        \raggedright
        \ifx\@empty\uea@pandc\else
          \textbf{\uea@pandc} \\*[\baselineskip]
        \fi
        \toname \\
        \toaddress
      \end{minipage}%
      \begin{minipage}[t]{0mm}
        \vspace*{32mm}%
      \end{minipage}
      \@date
    \end{minipage}%
    \begin{minipage}[t]{40mm}
      \hspace*{40mm}%
      \vspace*{50mm}%
    \end{minipage}%
    \begin{minipage}[t]{50mm}
      \vspace*{-3mm}%
      \footnotesize
      \raggedright
      \ifx\@empty\fromfaculty
        \ifx\@empty\fromschool\else
          \ignorespaces\fromschool \\*[\baselineskip]
        \fi
      \else
        \ifx\@empty\fromschool
          \textbf{\ignorespaces\fromfaculty} \\*[\baselineskip]
        \else
          \textbf{\ignorespaces\fromfaculty} \\
          \ignorespaces\fromschool \\*[\baselineskip]
        \fi
      \fi
      \ifx\@empty\fromaddress\else
        \ignorespaces\fromaddress \\*[\baselineskip]
      \fi
      \ifx\@empty\fromemail\else
        Email: \ignorespaces\fromemail \\
      \fi
      \ifx\@empty\telephonenum\else
        Tel: \ignorespaces\telephonenum \\
      \fi
      \ifx\@empty\fromfax\else
        Fax: \ignorespaces\fromfax \\
      \fi
      \ifx\@empty\fromweb\else
        \ignorespaces\fromweb \\
      \fi
    \end{minipage}%
  \end{wider}
  \par\noindent#1\par\nobreak
  {\bfseries
   \ifx\@empty\lettersubject\else
     \expandafter\uea@MakeUppercase\lettersubject \\\@empty
   \fi}}
\def\uea@MakeUppercase#1\\#2\@empty{%
  \MakeUppercase{#1}%
  \ifx\@empty#2\@empty\else
    \\ \expandafter\uea@MakeUppercase#2\@empty
  \fi}
\renewcommand\closing[1]{%
  \par\nobreak\vspace{\parskip}%
  \stopbreaks
  \noindent
  \ignorespaces #1%
  \ifx\fromsigfile\@empty
    \\[22 mm]
  \else
    \\[1 mm]
    \includegraphics{\fromsigfile}\\[1 mm]
  \fi
  \ifx\@empty\fromsig
    \fromname \\
  \else
    \fromsig \\
  \fi
  \ifx\@empty\fromposition\else
    \fromposition \\
  \fi
  \ifx\@empty\fromsignphone\else
    \fromsignphone \\
  \fi
  \ifx\@empty\fromsignemail\else
    \fromsignemail \\
  \fi
  \strut
  \par}
\renewcommand*\stopletter{\vfill}
\renewcommand*\today{%
  \number\day
  \space
  \ifcase\month\or
    January\or
    February\or
    March\or
    April\or
    May\or
    June\or
    July\or
    August\or
    September\or
    October\or
    November\or
    December%
  \fi
  \space
  \number\year
}
%% 
%% Copyright (C) 2008,2010 by
%%   Joseph Wright <joseph.wright@uea.ac.uk>
%% 
%% It may be distributed and/or modified under the conditions of
%% the LaTeX Project Public License (LPPL), either version 1.3c of
%% this license or (at your option) any later version.  The latest
%% version of this license is in the file:
%% 
%%    http://www.latex-project.org/lppl.txt
%% 
%% This work is "maintained" (as per LPPL maintenance status) by
%%   Joseph Wright.
%% 
%% This work consists of the file  uealttr.dtx
%%           and the derived files uealttr.cls,
%%                                 uealttr.ins and
%%                                 uealttr.pdf.
%% 
%%
%% End of file `uealttr.cls'.
