%%
%% This is file `ueaassig.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% ueaassig.dtx  (with options: `ueaassig.cls,package')
%% 
%%  ueaassig.dtx
%%  Copyright 2012 Nicola Talbot
%% 
%%  This work may be distributed and/or modified under the
%%  conditions of the LaTeX Project Public License, either version 1.3
%%  of this license of (at your option) any later version.
%%  The latest version of this license is in
%%    http://www.latex-project.org/lppl.txt
%%  and version 1.3 or later is part of all distributions of LaTeX
%%  version 2005/12/01 or later.
%% 
%%  This work has the LPPL maintenance status `maintained'.
%% 
%%  The Current Maintainer of this work is Nicola Talbot.
%% 
%%  This work consists of the files ueaassig.dtx and ueaassig.ins and the derived files ueaassig.cls, sample.tex.
%% 
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
%% See ueaassig.dtx for documented source code
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{ueaassig}[2012/01/15 3.01 (NLCT)]
\newcommand*{\setptsize}[1]{\def\assign@ptsize{#1}}
\setptsize{12}
\DeclareOption{10pt}{\setptsize{10}}
\DeclareOption{11pt}{\setptsize{11}}
\DeclareOption{12pt}{\setptsize{12}}
\DeclareOption{14pt}{\setptsize{14}}
\DeclareOption{17pt}{\setptsize{17}}
\DeclareOption{20pt}{\setptsize{20}}
\newcommand*{\setassignpapersize}[1]{\def\@assign@paper@size{#1paper}}
\setassignpapersize{a4}
\DeclareOption{a4paper}{\setassignpapersize{a4}}
\DeclareOption{a3paper}{\setassignpapersize{a3}}
\newif\ifusetimes
\usetimestrue
\DeclareOption{times}{\usetimestrue}
\DeclareOption{notimes}{\usetimesfalse}
\ProcessOptions
\edef\@assign@art@opts{\@assign@paper@size,\assign@ptsize pt}
\ifnum\assign@ptsize>12
   \expandafter\LoadClass\expandafter[\@assign@art@opts]{extarticle}
\else
   \expandafter\LoadClass\expandafter[\@assign@art@opts]{article}
\fi
\RequirePackage{amsmath}
\RequirePackage{calc}
\RequirePackage{url}
\RequirePackage{parskip}
 \setlength{\textwidth}{7.0in}
 \addtolength{\hoffset}{-1.0in}
 \addtolength{\voffset}{-1.0in}
 \addtolength{\textheight}{1in}
\ifusetimes
  \RequirePackage{lmodern}
  \RequirePackage{mathptmx}
  \RequirePackage[scaled=.92]{helvet}
  \RequirePackage{courier}
\fi
\RequirePackage{flowfram}
\newflowframe[1]{\textwidth}{\textheight}{0pt}{0pt}[title]
\newflowframe*[>1]{\textwidth}{\textheight}{0pt}{0pt}[details]
\newflowframe[none]{\textwidth}{\textheight}{0pt}{0pt}[submission]
\newcommand*{\ps@ueaassig}{%
   \renewcommand*{\@oddhead}{}%
   \renewcommand*{\@evenhead}{}%
   \renewcommand*{\@oddfoot}{%
     \hfill Page \thepage\space of \pageref{pg:lastpage}\hfill
     \llap{\textbf{\@submissionoverleaf}}}%
   \renewcommand*{\@evenfoot}{%
     \hfill Page \thepage\space of \pageref{pg:lastpage}\hfill
     \rlap{\textbf{\@submissionoverleaf}}}%
}
\pagestyle{ueaassig}
\newcommand*{\@submissionoverleaf}{}
\newenvironment{titleinfo}%
  {%
    \gdef\@no@titlefound{}%
  }%
  {%
    \maketitle
    \@disable@titlecommands
  }
\newcommand*{\@no@titlefound}{%
  \ClassError{ueaassig}{No `titleinfo' environment found}%
  {You must use the `titleinfo' environment to specify
  the information for the title page}%
}
\newcommand*{\@disable@titlecommands}{}
\newcommand*{\@title@command}[1]{%
  \expandafter\toks@\expandafter{\@disable@titlecommands}%
  \edef\@disable@titlecommands{\the\toks@
    \noexpand\gdef\noexpand#1{\noexpand\@titlecommand@err{\noexpand#1}}%
  }%
}
\newcommand*{\@titlecommand@err}[1]{%
  \ClassError{ueaassig}{Command \string#1\space may only be used in
    or before `titleinfo' environment}{}%
}
\newcommand{\university}[1]{\renewcommand{\@university}{#1}}
\newcommand{\@university}{University of East Anglia}
\@title@command\university
\newcommand{\@school}{School of Computing Sciences}
\newcommand{\school}[1]{\renewcommand{\@school}{#1}}
\@title@command\school
\newcommand{\@unit}{\ClassError{ueaassig}{Missing \string\unit}{You
need to specify the unit name and code using \string\unit{name}}}
\newcommand{\unit}[1]{\renewcommand{\@unit}{{#1}}}
\@title@command\unit
\newcommand{\@submissiondate}{}
\newcommand{\submissiondate}[1]{\renewcommand{\@submissiondate}{#1}}
\@title@command\submissiondate
\newcommand{\@returndate}{}
\newcommand{\returndate}[1]{\renewcommand{\@returndate}{#1}}
\@title@command\returndate
\newcommand{\@assignvalue}{}
\newcommand{\assignvalue}[1]{\renewcommand{\@assignvalue}{#1}}
\@title@command\assignvalue
\newcommand{\@setby}{}
\newcommand{\setby}[1]{\renewcommand{\@setby}{#1}}
\@title@command\setby
\newcommand{\@checkedby}{}
\newcommand{\checkedby}[1]{\renewcommand{\@checkedby}{#1}}
\@title@command\checkedby
\newcommand{\@aim}{\rule{0pt}{20pt}}
\newcommand{\aim}[1]{\renewcommand{\@aim}{#1}}
\@title@command\aim
\newcommand{\@learning}{\rule{0pt}{10pt}}
\newcommand{\learning}[1]{\renewcommand{\@learning}{#1}}
\@title@command\learning
\newcommand{\@criteria}{\rule{0pt}{20pt}}
\newcommand{\criteria}[1]{%
  \renewcommand{\@criteria}{#1}%
}
\@title@command\criteria
\newcommand{\subjectspecific}[1]{%
  \item[\mdseries\itshape Subject specific]\mbox{}\newline#1%
  \par\vskip\baselineskip
}
\@title@command\subjectspecific
\newcommand{\transferable}[1]{%
  \item[\mdseries\itshape Transferable skills]\mbox{}\newline#1%
  \par\vskip\baselineskip
}
\@title@command\transferable
\newcommand{\proglabel}{Listing}
\newcounter{programme}
\newenvironment{programme}[1]{%
  \refstepcounter{programme}%
  \def\@programmecap{#1}%
  \begin{ttfamily}%
}%
{%
  \end{ttfamily}\par
  \begin{center}
    \proglabel\ \theprogramme\ : \@programmecap
  \end{center}%
}
\newenvironment{assignment}{%
  \section*{Description of the Assignment}%
}%
{%
}
\newenvironment{guidelines}{%
  \section*{General Guidelines}%
}%
{%
}
\newenvironment{assessment}{%
  \section*{Assessment}%
}%
{%
}
\newenvironment{marksawarded}{%
  \subsection*{Marks will be awarded as follows}%
  \def\submark##1##2{\item[##1\%]##2}%
  \begin{description}%
}%
{%
  \end{description}%
}
\newlength\latetabwidth
\newenvironment{submission}{%
  \def\@submissionoverleaf{Submission instructions overleaf.}%
  \edef\@set@frames{%
    \noexpand\setflowframe*{details}{pages={\number\c@page}}%
    \noexpand\setflowframe*{submission}{pages={>\number\c@page}}%
  }%
  \@set@frames
  \par
  \clearpage
  \def\@submissionoverleaf{}%
  \section*{Submission Procedure}%
}%
{%
  \postsubmissiontext
  \subsection*{Deadlines}%
  Coursework should be submitted before \textbf{23:59} on the
  deadline day. Work is to be submitted via the Hub drop boxes
  up to \textbf{22:00} in the LTS Hub, and there will be a late
  box in the Library for submissions between \textbf{22:00} and
  \textbf{midnight}.\par
  If coursework is handed in after the deadline day or an agreed
  extension:\par
  {\centering
    \setlength\latetabwidth{0.5\linewidth-2\tabcolsep-2\arrayrulewidth}%
    \begin{tabular}{|p{\latetabwidth}|p{\latetabwidth}|}
    \hline
    \strut
    \bfseries Work submitted & \bfseries Marks deducted\\\hline
    \strut On the day following the due date &
    10 marks\\\hline
    \strut On either the 2nd or 3rd day after the due date &
    20 marks\\\hline
    \strut On the 4th day after the due date and before the 20th day
    after the due date &
    All the marks the work merits if submitted on time (i.e.\ no
    marks awarded)\\\hline
    \strut After 20 working days &
    Work will not be marked and a mark of zero will be entered
    \\\hline
    \end{tabular}
  \par
  }%
  All extension requests will be managed through the LTS Hub. A
  request for an extension to a deadline for the submission of work
  for assessment should be submitted by the student to the appropriate
  Learning and Teaching Service Hub, prior to the deadline, on a
  University Extension Request Form accompanied by appropriate
  evidence. Extension requests will be considered by the appropriate
  Learning and Teaching Service Manager in those instances where
  \textbf{(a)} acceptable extenuating circumstances exist and
  \textbf{(b)} the request is submitted before the deadline. All other
  cases will be considered by a Coursework Coordinate in \textbf{CMP}.
  \par
  \fbox{%
    \begin{minipage}{\linewidth-\fboxsep}%
    \textbf{Plagiarism:} Plagiarism is the copying of close
    paraphrasing of published or unpublished work, including
    the work of another student; without due acknowledgement.
    Plagiarism is regarded a serious offence by the University,
    and all cases will be investigated. Possible consequences
    of plagiarism include deduction of marks and disciplinary
    action, as detailed by UEA's Policy on Plagiarism and
    Collusion.
    \end{minipage}%
  }%
  \label{pg:lastpage}%
}
\newcommand{\postsubmissiontext}{%
  \par
  Written coursework should be submitted by following the standard
  CMP practice. Students are advised to refer to the Guidelines and
  Hints on Written Work in CMP
  (\url{http://www.uea.ac.uk/cmp/links/Reports}).
}
\renewcommand\maketitle{%
  \thispagestyle{empty}%
  \begin{bfseries}\large
    \noindent COURSEWORK ASSIGNMENT \hfill
    \begin{tabular}[t]{r}
    \MakeUppercase\@university\\
    \@school
    \end{tabular}\\
    \begin{tabular}{@{}ll}
      UNIT : & \mdseries \@unit\\
      ASSIGNMENT TITLE : & \mdseries \@title
    \end{tabular}
    \par\vskip20pt
    \noindent
    \begin{tabular}{@{}l@{\qquad: }ll}
      DATE SET & \multicolumn{2}{@{}l}{\mdseries \@date}\\
      DATE OF SUBMISSION & \multicolumn{2}{@{}l}{\mdseries\@submissiondate}\\
      RETURN DATE & \multicolumn{2}{@{}l}{\mdseries\@returndate}\\
      ASSIGNMENT VALUE & \mdseries\@assignvalue\%\\
      SET BY & \mdseries \@setby & SIGNED:\\
      CHECKED BY & \mdseries\@checkedby & SIGNED:
    \end{tabular}
  \end{bfseries}\par
  \vskip\baselineskip
  \noindent
  \fbox{%
    \begin{minipage}{\linewidth-2\fboxsep}
    \textbf{Aim:}%
      \par\vskip\baselineskip
    \begin{description}
      \@aim
    \end{description}
    \textbf{Learning outcomes:}%
      \par\vskip\baselineskip
    \begin{description}
      \@learning
    \end{description}
    \textbf{Assessment criteria:}%
      \par\vskip\baselineskip
    \begin{description}
      \item\hskip\leftmargin\hskip-.5em\@criteria
    \end{description}
    \end{minipage}
  }%
  \clearpage
}
\AtEndDocument{\@no@titlefound}
\endinput
%%
%% End of file `ueaassig.cls'.
