#!/usr/bin/perl -W
# File    : quotepas
# Date    : 23/12/2005
# Author  : Nicola L.C. Talbot
# Purpose : Helper application for use with the quotepas 
#           LaTeX package. Reads in information from auxiliary
#           file.
# Syntax: quotepas <aux file> <database>
# Writes output to file specified by \@quotepasdatabase in
# aux file.

die "Syntax: quotepas <aux file> <database>\n"
    unless ($#ARGV == 1);

open AUX, $ARGV[0] or die "Unable to open '$ARGV[0]': $!\n";

while (<AUX>)
{
   if (m/\\\@quotepasdatabase\{(.+)\}/)
   {
      $outfile = $1;
      # does it have an extension?
      unless ($outfile=~/\.\w{3}$/)
      {
         $outfile .= ".tex";
      }
   }
   elsif (m/\\\@quotepas\{(.+)\}/)
   {
      $quote{$1}='<not found>';
   }
}

close AUX;

die "no quotepasdatabase found in $ARGV[0]\n" unless defined ($outfile);

die "no quotepas found in $ARGV[0]\n" unless defined %quote;

open XML, $ARGV[1] or die "Unable to open '$ARGV[1]': $!\n";

$pre = '';
while (<XML>)
{
   next if m/^\s*$/;
   $quotepas = $pre.$_;

   unless ($quotepas=~m/\s*<quotepas>/)
   {
      die "<quotepas> expected on line $. but found $_";
   }

   unless ($quotepas=~m/<\/quotepas>/)
   {
      while (<XML>)
      {
         $quotepas.=$_;
         last if ($quotepas=~m/<\/quotepas>/);
      }
   }

   $quotepas=~s/<quotepas>(.*)<\/quotepas>(.*)/$1/s;
   $pre = $2;

   if ($quotepas=~m/<quotepas>/)
   {
      warn "Line $.: nested <quotepas> or missing </quotepas>\n";
   }

   unless ($quotepas=~m/<label>/)
   {
      warn "Line $.: no <label> found\n";
      next;
   }

   unless ($quotepas=~m/<\/label>/)
   {
      warn "Line $.: no </label> found\n";
      next;
   }

   unless ($quotepas=~m/<label>(.*)<\/label>/s)
   {
      warn "Line $.: ill-formed <label>\n";
      next;
   }

   $label = $1;

   unless ($quotepas=~m/<block>/)
   {
      warn "Line $.: no <block> found\n";
      next;
   }

   unless ($quotepas=~m/<\/block>/)
   {
      warn "Line $.: no </block> found\n";
      next;
   }

   unless ($quotepas=~m/<block>(.*)<\/block>/s)
   {
      warn "Line $.: ill-formed <block>\n";
      next;
   }

   $block = $1;

   if (defined($quote{$label}))
   {
      $quote{$label}=$block;
   }
}

close XML;

open OUTFILE, ">$outfile" or die "unable to open '$outfile': $!\n";

foreach $label (keys %quote)
{
   if ($quote{$label} eq '<not found>')
   {
      warn "Quote '$label' not found\n";
      next;
   }

   print OUTFILE "\\newquotepas{$label}{$quote{$label}}\n\n";
}

close OUTFILE;

1;
