% Generalised kernel machine toolbox.
%
%    Object types:
%
%       gkm       - the generalised kernel machine.
%       criterion - base class for all performance criteria.
%       estimator - base class for all performance estimation methods.
%       selector  - base class for all model selection procedures.
%       kernel    - base class for all kernel objects.
%
%    Generalised kernel machines:
%
%       klr       - kernel logistic regression.
%       krr       - kernel ridge regression.
%       optimised - wrapper implementing automated model selection. 
%
%    Criterion objects
%
%       erate - mis-classification rate.
%       nll   - negative log-likelihood.
%       sse   - sum-of-squared error.
%
%    Estimator objects
%
%       aloo             - approximate leave-one-out cross-validation.
%       cross-validation - k-fold and leave-one-out cross-validation.
%       multisplit       - multiple random training/test split.
%       resubstitution   - performance on training set.
%       splitsample      - performance on separate validation/test split.
%
%    Selector objects:
%
%       simplex    - Nelder-Mead simplex optimisation.
%       gridsearch - simple grid-based search heuristic.
%
%    Kernel objects:
%
%       linear     - linear kernel.
%       polynomial - inhomogenous polynomial kernel.
%       rbf        - Gaussian radial basis function kernel.
