function net = train(net, x, y, varargin)
%
% TRAIN - train an optimised GKM
%
%    NET=TRAIN(NET,X,Y) trains a generalised kernel machine, NET, using the
%    input vectors, X, and responses, Y.

%
% File        : @optimised/train.m
%
% Date        : Thursday 28th April 2005
%
% Author      : Dr Gavin C. Cawley
%
% Description : Train an optimised GKM, including model selection. 
%
% History     : 28/04/2005 - v1.00 
%
% Copyright   : (c) Dr Gavin C. Cawley, April 2005.
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
%

net.gkm = select(net.selector, net.gkm, x, y, varargin{:});

% bye bye...

