function net = setproperty(net, property, value)
%
% SETPROPERTY - set property of an optimised GKM object
%
%    C = SETPRPROPERTY(NET,'PROPERTY',VALUE) set the named PROPERTY of an
%    optimised GKM object, NET, to the given VALUE.

%
% File        : @optimsied/setproperty.m
%
% Date        : Friday 24th August 2007
%
% Author      : Dr Gavin C. Cawley
%
% Description : Set the value of the named property of an estimator object.
%
% History     : 24/08/2007 - v1.00
%
% Copyright   : (c) Dr Gavin C. Cawley, August 2007.
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
%

if strcmp(property, 'gkm')

   net.gkm = value;

elseif strcmp(property, 'selector')

   net.selector = value;

else

   gkm = setproperty(net.gkm, property, value);

   if isempty(gkm) & iscell(gkm)

      selector = setproperty(net.selector, property, value);

      if isempty(selector) & iscell(selector)

         net = {};

      else

         net.selector = selector;

      end

   else

      net.gkm = gkm;

   end

end

% bye bye...

