function e = multisplit(varargin)
%
% MULTISPLIT - multiple random split sample performance estimator 

%
% File        : @multisplit/multiplit.m
%
% Date        : Sunday 26th August 2007
%
% Author      : Dr Gavin C. Cawley
%
% Description : Multiple random split-sample estimaator for performance
%               evaluation and model selection for generalised kernel machines.
%
% History     : 26/08/2007 - v.100
%
% Copyright   : (c) Dr Gavin C. Cawley, August 2007.
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
%

if nargin == 0
   
   % this is the default constructor
   
   e.folds = 10;
   e.ratio = 0.5;
   e.seed  = 42;
   e       = class(e, 'multisplit', estimator('type', 'multiple split-sample'));
   
else

   % set all parameters

   e = set(multisplit, varargin{:});

end

% bye bye...

