function L = estimate(e, model, x, y, varargin)
%
% ESTIMATE - evaluate multiple split estimate of a performance criterion
%
%    L = ESTIMATE(CROSSVALIDATION,MODEL,X,Y) estimates the value of a
%    performance criterion on test data, using a multiple random split-sample
%    procedure, for data (X,Y).

%
% File        : @multisplit/mulipslit.m
%
% Date        : Sunday 26th August 2007
%
% Author      : Dr Gavin C. Cawley
%
% Description : Evaluate a multiple random split-sample performance estimate
%               for a generalised kernel machine.
%
% History     : 26/08/2007 - v1.00
%
% Copyright   : (c) Dr Gavin C. Cawley, August 2007.
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
%

% generate random test/training splits

ntp   = sie(x,1);
state = rand('state');
rand('state', e.seed);
[foo,idx] = sort(rand(ntp,e.n));
rand('state', state);

% perform evaluation using multiple training/test splits

criterion = get(e, 'criterion'); 
ntp       = floor(e.ratio*ntp);

for i=1:e.folds

   tr        = idx(1:ntp,i);
   te        = idx((ntp+1):end,i);
   m         = train(model, x(tr,:), y(tr), varargin{:});
   [mu,eta]  = fwd(model, x(te,:));
   L(i)      = evaluate(criterion, model, y(te), mu, eta);

end

L = sum(L);

% bye bye...

