function net = klr(varargin)
%
% KLR - kernel logistic regression machine
%
%    MODEL = KLR('KERNEL',RBF,'LAMBDA',1) constructs a kernel logistic
%    regression model, optionally specifying a Gaussian radial basis function
%    kernel, and an initial value for the regularisation parameters, LAMBDA.
%
%    The toolbox provides a concrete implementation of the kernel logistic
%    regression machine for users without the symbolic math toolbox. 
%
%    See also: GKM

%
% File        : @klr/klr.m
%
% Date        : Friday 24th August 2007
%
% Author      : Dr Gavin C. Cawley
%
% Description : Constructor for a class implementing the kernel logistic 
%               regression machine.
%
% History     : 24/08/2007 - v1.00
%
% Copyright   : (c) Dr Gavin C. Cawley, August 2007.
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
%

if nargin == 0

   net.dummy = [];
   net = class(net, 'klr', gkm);
   net = set(net, 'acronym',    'klr', ...
            'name',       'kernel logistic regression machine', ...
            'invlink',    inline('exp(eta)./(1+exp(eta))', 'eta'), ...
            'loss',       inline('-(y.*eta -log(1+exp(eta)))','y','eta'), ...
            'W',          inline('exp(eta)./(1+exp(eta)).^2','eta'), ...
            'canonical',  'log(1+exp(eta))');

else

   net = set(klr, varargin{:});
   
end

% bye bye...

