function s = gridsearch(varargin)
%
% GRIDSEARCH - grid-search based model selector
%
%    S = GRIDSEARCH creates a new model selection object for tuning the 
%    hyper-parameters of a generalised kernel machines using a simple
%    grid-based search procedure.
%
%    S = SIMPLEX('ESTIMATOR',SPLITSAMPLE) specifies that a split-sample
%    estimator is to be used for model selection in place of the default
%    approximate leave-one-out cross-validation estimator (ALOO).
%
%    S = SIMPLEX('PARAMETER',VALUE,...) optionally initialised the values
%    of one or more optimisation parameters, specified by a sequence of
%    name-value pairs.  The following optimisation parameters are available:
%
%       min   - minimum value of the grid
%       max   = maximum value of the grid
%       step  = increment between points on the grid.
%
%   If min, max and step are scalars, the grid used the same intervals for
%   all hyper-parameters.  If min, max and step are vectors, they must be of
%   the same dimensions as the 'paramaters' property of the generalised kernel
%   machine.  This permits different intervals to be specified for different
%   hyper-parameters. The default values for these optimisation parameters are
%   as follows:
%
%       min   = -3;
%       max   = +3;
%       step  = +1;
%
%    See also: SELECTOR/SELECT, ESTIMATOR

%
% File        : @gridsearch/gridsearch.m
%
% Date        : Monday 27th August 2007
%
% Author      : Dr Gavin C. Cawley
%
% Description : Constructor for a class implementing a simple grid-based search
%               model selection procedure for generalised kernel machines.
%
% Copyright   : (c) Dr Gavin C. Cawley, August 2007.
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
%

if nargin == 0
   
   % this is the default constructor
   
   s.min   = -3;
   s.max   = +3;
   s.step  = 1;
   s.cost  = realmax;
   s.evals = 0;
   s       = class(s, 'gridsearch', selector('type', 'grid-search'));
   
else
   
   s = set(gridsearch, varargin{:});
  
end

% bye bye...

