function P = generate(s, p, n);
%
% GENERATE - generate list of hyper-parameters to be investigated

%
% File        : @gridsearch/generate.m
%
% Date        : Monday 27th August 2007
%
% Author      : Dr Gavin C. Cawley
%
% Description : Recursively form a list of hyper-parameter values to be
%               investigated during a grid-based model selection procedure
%               for generalised kernel machines.
%
% History     : 27/08/2007 - v1.00
%
% Copyright   : (c) Dr Gavin C. Cawley, August 2007.
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
%

if nargin == 1

   P = generate(s, s.min, 1); 

else

   if n <= length(s.min)

      P      = [];
      values = s.min(n):s.step(n):s.max(n);

      for i=1:size(p, 1)

         rho      = repmat(p(i,:), length(values), 1);
         rho(:,n) = values';

         for j=1:length(values)

            P = [P ; generate(s, rho(j,:), n+1)]; 

         end
 
      end

   else

      P = p;

   end

end

P = fliplr(unique(fliplr(P), 'rows'));

% bye bye...

