%
% SYNTHETIC - Kernel logistic regression on Ripley's synthetic dataset
%

% start from a clean slate

clear all;

% extend search path

addpath ../../data;
addpath ../../gkmtools;

% load data

load synthetic.mat

x = x_train;
y = y_train;

% fix instance of a generalised kernel machine

fprintf(1, 'fixing klr instance of a generalised kernel machine...\n');

if 0
fix(gkm('acronym', 'klr', ...
        'name',    'kernel logistic regression machine', ...
        'canonical',  'log(1+exp(eta))'));
end

% construct kernel logistic regression model

fprintf(1, 'constructing klr machine...\n');

network = klr('kernel',    rbf('eta', [1;1]), ...
              'lambda',    0.01, ...
              'Verbosity', 'ethereal');

% perform model selection

fprintf(1, 'performing model selection...\n');

selector = simplex('estimator', aloo, 'TolFun', 1e-4, 'TolX', 1e-4);
%net      = select(selector, network, x_train, y_train, x_test, y_test);
net      = train(network, x_train, y_train);

% plot results

fprintf(1, 'plotting results...\n');

figure(1);
clf;
set(axes, 'FontSize', 14);
h1 = plot(x(y == 1, 1), x(y == 1, 2), 'rx');
hold on;
h2 = plot(x(y == 0, 1), x(y == 0, 2), 'b+');
a = axis;
[X,Y] = meshgrid(a(1):0.025:a(2),a(3):0.025:a(4));
X2    = [reshape(X,prod(size(X)),1) reshape(Y,prod(size(X)),1)];
o     = fwd(net, X2);
o     = reshape(o,size(X));
hold on
[c,h4] = contour(X, Y, o, [+0.9 +0.9], 'r--');
[c,h5] = contour(X, Y, o, [+0.5 +0.5], 'g-');
[c,h6] = contour(X, Y, o, [+0.1 +0.1], 'b-.');
hold off
handles = [h1 ; h2 ; h4(1) ; h5 ; h6];
set(handles, 'LineWidth', 1);
legend(handles, 'class 1', 'class 2', 'p = 0.9', 'p = 0.5', 'p = 0.1', 'Location', 'NorthWest');
xlabel('x_1');
ylabel('x_2');
drawnow;

% performance estimation

mu_train = fwd(net, x_train);
mu_test  = fwd(net, x_test);

erate_train    = mean((mu_train>=0.5) ~= y_train);
erate_aloo     = estimate(aloo('criterion', erate), net, x, y);
erate_xval     = estimate(crossvalidation('k',10,'criterion',erate),net,x,y);
erate_test     = mean((mu_test >=0.5) ~= y_test);
erate_unbiased = estimate(crossvalidation('k', 10, 'criterion', erate), ...
                    optimised('gkm', network, 'selector', selector), ...
                    x_train, y_train);

fprintf(1, '\n');
fprintf(1, 'PERFORMANCE ESTIMATES\n');
fprintf(1, '=====================\n');
fprintf(1, '\n');
fprintf(1, '     training error = %6.2f%%\n', 100*erate_train);
fprintf(1, '        l-o-o error = %6.2f%%\n', 100*erate_aloo);
fprintf(1, ' 10-fold xval error = %6.2f%%\n', 100*erate_xval);
fprintf(1, 'unbiased xval error = %6.2f%%\n', 100*erate_unbiased);
fprintf(1, '      testing error = %6.2f%%\n', 100*erate_test);
fprintf(1, '\n');

% bye bye...

