%
% MCYCLE.M - demonstrate kernel ridge regression on Silverman's motorycle data
%

% start from a clean slate

clear all

% extend search path

addpath ../../data
addpath ../../gkmtools

% load training data

fprintf(1, 'loading training data...\n');

load ../data/mcycle

% fix instance of a generalised kernel machine

if 0

   fprintf(1, 'fixing krr instance of a generalised kernel machine...\n');

   fix(gkm('acronym',   'krr', ...
           'name',      'kernel ridge regression', ...
           'canonical', '0.5*eta^2'));

end

% construct kernel ridge regression model

fprintf(1, 'constructing krr machine...\n');

net = krr('kernel', rbf('eta', 1), 'lambda', 1, 'Verbosity', 'ethereal');

% perform model selection

fprintf(1, 'performing model selection...\n');

estimator = aloo;
selector  = simplex('estimator', estimator, 'TolFun', 1e-6, 'TolX', 1e-6);
net       = select(selector, net, x, t);

% plot results

fprintf(1, 'plotting results...\n');

X = (min(x):0.1:max(x))';
y = fwd(net, X);

clf;
set(axes, 'FontSize', 14);
plot(x,t,'g+',X,y(:,1),'r-', 'LineWidth', 1);
xlabel('Time (ms)');
ylabel('Acceleration (g)');

print -depsc2 mcycle.eps

% bye bye...

