%
% CANCER - Kernel Poisson regression on Andersen's lung cancer dataset
%

% start from a clean slate

clear all;

% extend search path

addpath ../../data;
addpath ../../gkmtools;

% load data

load cancer.txt

% set up a few useful constants

x = cancer(:,1:4);
y = cancer(:,5)./cancer(:,6);

clear cancer;

% fix instance of a generalised kernel machine

fprintf(1, 'fixing kpor instance of a generalised kernel machine...\n');

fix(gkm('acronym', 'kpor', ...
        'name',    'kernel Poisson regression', ...
        'canonical',  'exp(eta)'));

% construct kernel logistic regression model

fprintf(1, 'constructing kpor machine...\n');

net = kpor('kernel',   polynomial('d', 2, 'c', 1), ...
          'lambda',    1, ...
          'Verbosity', 'ethereal');

% perform model selection

fprintf(1, 'performing model selection...\n');

selector = simplex('estimator', aloo, 'TolFun', 1e-6, 'TolX', 1e-6);
net      = select(selector, net, x, y);

% compute model predictions

X           = [40:0.1:80]';
XX          = [X repmat([1 0 0], length(X), 1)];
y_fredricia = fwd(net, XX);
XX          = [X repmat([0 1 0], length(X), 1)];
y_horsens   = fwd(net, XX);
XX          = [X repmat([0 0 1], length(X), 1)];
y_kolding   = fwd(net, XX);
XX          = [X repmat([0 0 0], length(X), 1)];
y_vejle     = fwd(net, XX);

% plot results

figure(1);
clf;
set(axes, 'FontSize', 14, 'LineWidth', 2);
h=plot(x(1:6,1),   y(1:6),      'r.', ...
       X,          y_fredricia, 'r-', ... 
       x(7:12,1),  y(7:12),     'bs', ...
       X,          y_horsens,   'b--', ... 
       x(13:18,1), y(13:18),    'go', ...
       X,          y_kolding,   'g-.', ... 
       x(19:24,1), y(19:24),    'k+', ...
       X,          y_vejle,     'k:', ...
       'LineWidth', 1);
axis([40 80 0 0.025]);
legend('Fredricia data', 'Fredricia fit', ...
       'Horsens data',   'Horsens fit', ...
       'Kolding data',   'Kolding fit', ...
       'Vejle data',     'Vejle fit', ...
       'Location',       'NorthWest');
xlabel('Age');
ylabel('Rate = cases/population');

print -depsc2 cancer.eps

% bye bye...

