function [model, index] = train(x_train, t_train)

% standardise input data

[x_train, scale, offset] = standardise(x_train);

% add unregularised bias parameter

x_train = [ones(size(x_train,1),1) x_train];

% train model

alpha        = blogreg(x_train, t_train, 1e-6);
index        = find(alpha~=0);
model.alpha  = alpha(index);
index        = index(2:end)-1;
model.scale  = scale(index);
model.offset = offset(index);

% all done...

