function [x,scale,offset] = standardise(x,scale,offset)

%
% STANDARDISE - standardise a dataset
%
%       [y,scale,offset] = standardise(x);
%
%    standardises a data set, x, such that each variable has a mean of zero
%    and unit variance.  Each row of x represents an observation, and each
%    column a variable.  Each column of x is standardised separately by
%    subtracting the mean (offset) and dividing by the square root of the
%    variance (scale).
%

%
% File        : standardise.m
%
% Date        : Wednesday 19th September 2001
%
% Author      : Dr Gavin C. Cawley
%
% Description : Standardise a data set such that each variable has a mean of
%               zero and unit variance.
%
% History     : 20/12/1998 - v1.00
%               27/07/2001 - v1.10 now computes variance and mean in a more
%                                  memory efficient manner
%               19/09/2001 - v1.20 a little slower, but maximally memory
%                                  efficent version
%
% Copyright   : (c) Dr Gavin Cawley, September 2001.
%

[n,d] = size(x);

if nargin ==1

   s               = sum(x);
   r               = sum(x.^2);
   scale           = sqrt((r - (s.^2)/n)/(n-1));
   offset          = s/n; 
   scale(scale==0) = 1;

end

for i=1:d

   x(:,i) = (x(:,i) - offset(i))/scale(i);

end

% bye bye 

