function varargout = blogreg(varargin)

%
% BLOGREG - Bayesian logistic regression 
%
%    alpha = blogreg(x, t, tol)

%
% File        : blogreg.m
%
% Date        : Saturday 2nd October 2004
%
% Author      : Gavin C. Cawley
%
% Description : Simple veneer for hiding MEX files from the user by
%               tranparently compiling them the first time they are used.
%
% History     : 02/10/2004 - v1.00
%
% Copyright   : (c) Dr Gavin C. Cawley, October 2004.
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
%

% store the current working directory

cwd = pwd;

% find out name of the currently running m-file (i.e. this one!)

name = mfilename;

% find out what directory it is defined in

dir             = which(name);
dir(dir == '\') = '/';
dir             = dir(1:max(find(dir == '/')-1));

% try changing to that directory

try

   cd(dir);

catch

   % this should never happen, but just in case!

   cd(cwd);

   error(['unable to locate directory containing ''' name '.m''']);

end

% try recompiling the MEX file

try

   mex([name '.c'], '-lm');

catch

   % this may well happen happen, get back to current working directory!

   cd(cwd);

   error('unable to compile MEX version of ''%s''%s\n%s%s', name, ...
         ', please make sure your', 'MEX compiler is set up correctly', ...
         ' (try ''mex -setup'').');


end

% change back to the current working directory

cd(cwd);

% refresh the function and file system caches

rehash;

% try to invoke MEX version using the same input and output arguments

varargout{:} = feval(name, varargin{:});

% bye bye...

