
%
% EXPERIMENT #002
%

% start from a clean sheet

clear all

% load data

load mammals.dat 
load dinosaurs.dat 

% train models

y_mammal   = log10(1000*mammals(:,end));
x_mammal   = log10(mammals(:,1) + mammals(:,2));
x_dinosaur = log10(dinosaurs);

% get on with it

w = [x_mammal ones(size(x_mammal))]\y_mammal;


Y_mammal   = [x_mammal   ones(size(x_mammal))]*w;
x_mammal   = 10.^x_mammal;
y_mammal   = 10.^y_mammal;
Y_mammal   = 10.^Y_mammal;

Y_mammal2 = 3.32590830116403*x_mammal.^2.12660397962140;

figure(1);
clf
set(axes, 'FontSize', 14);
plot(log10(x_mammal), 100*(Y_mammal  - y_mammal)./y_mammal, 'r+', ...
     log10(x_mammal), 100*(Y_mammal2 - y_mammal)./y_mammal, 'bo');
xlabel('log10(Humerus + Femur)');
ylabel('relative error %');
legend('conventional', 'non-linear regression','Location', 'NorthEast');
drawnow;
print -depsc2 figure2.eps

% all done...

