function value = getproperty(ker, property)

%
% GETPROPERTY - get individual kernel property 
%
%    value = getproperty(kernel, 'property') returns the value of the named
%    property for the specified kernel object.

%
% File        : @rbf/getproperty.m
%
% Date        : Friday 30th July 2004
%
% Author      : Dr Gavin C. Cawley
%
% Description : Accessor method used to retrieve individual RBF kernel
%               properties. 
%
% History     : 30/07/2004 - v1.00
%
% Copyright   : (c) Dr Gavin C. Cawley, July 2004
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
%  

if nargin ~= 2

   error('wrong number of parameters');

elseif strcmp(property, 'eta')

   value = ker.eta;

elseif strcmp(property, 'maxEta')

   value = ker.maxEta;

elseif strcmp(property, 'parameters')

   value = log(ker.eta)/log(2);

else

   value = getproperty(ker.kernel, property);

end

% bye bye...

