function [K,dK] = evaluate(ker, x1, x2)

%
% EVALUATE
%
%    Evaluate a radial basis function (RBF) kernel, for example
%
%       K = evaluate(kernel, x1, x2);
%
%    where x1 and x2 are matrices containing input patterns, where each column
%    represents a variable and each row represents an observation.

%
% File        : @rbf/evaluate.m
%
% Date        : Sunday 2nd February 2003
%
% Author      : Dr Gavin C. Cawley
%
% Description : Evaluate a radial basis function (RBF) kernel.  Part of an
%               object-oriented implementation of Vapnik's Support
%               Vector Machine, as described in [1].  
%
% References  : [1] V.N. Vapnik,
%                   "The Nature of Statistical Learning Theory",
%                   Springer-Verlag, New York, ISBN 0-387-94559-8,
%                   1995.
%
% History     : 02/02/2003 - v1.00
%
% Copyright   : (c) Dr Gavin C. Cawley, February 2003.
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
%

fprintf(1, 'SHITE!\n');

ones1 = ones(size(x1, 1), 1);
ones2 = ones(size(x2, 1), 1);

if size(ker.eta, 1) > 1

   eta = sqrt(ker.eta);

   x1 = x1.*(ones1*eta');
   x2 = x2.*(ones2*eta');

   D = sum(x1.^2,2)*ones2' + ones1*sum(x2.^2,2)' - 2*x1*x2';

   K = exp(-D);

   if nargout == 2

      for i=1:length(ker.eta)

      end

   end

else

   D = sum(x1.^2,2)*ones2' + ones1*sum(x2.^2,2)' - 2*x1*x2';
   K = exp(-ker.eta*D);

   % optionally compute derivative w.r.t. kernel parameter

   if nargout == 2

      dK(1,:,:) = -ker.eta*log(2).*K.*D;

   end

end


% bye bye...

