function varargout = get(obj, varargin)

% GET - get object properties 
%
%    value = get(object, 'property') returns the value of the specified
%    property for an object.

%
% File        : @object/get.m
%
% Date        : Friday 30th July 2004
%
% Author      : Dr Gavin C. Cawley
%
% Description : Generic accessor method used to retrieve object properties. 
%
% History     : 30/07/2004 - v1.00
%
% Copyright   : (c) Dr Gavin C. Cawley, July 2004
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
%  

if nargin == 1

   error(['no properties specified']);

else

   for i=1:size(varargin,2)

      varargout{i} = getproperty(obj, varargin{i});

      if isempty(varargout{i}) & iscell(varargout{i})

         error(['unknown property "' varargin{i} '"']);

      end

   end

end

% bye bye...

