function net = setproperty(net, property, value)

% SETPROPERTY - set model properties 
%
%    net = setproperty(net, 'property', value) sets the value of the specified
%    model property.

%
% File        : @klr/setproperty.m
%
% Date        : Friday 31st October 2003
%
% Author      : Dr Gavin C. Cawley
%
% Description : Mutator method used to set model properties. 
%
% History     : 31/10/2003 - v1.00
%
% Copyright   : (c) Dr Gavin C. Cawley, October 2003.
%

if strcmp(property, 'alpha')

   net.alpha = value;

elseif strcmp(property, 'criterion')

   net.criterion = value;

elseif strcmp(property, 'lambda')

   net.lambda = value;

elseif strcmp(property, 'kernel')

   net.kernel = value;

elseif strcmp(property, 'parameters')

   net.lambda = 2.^min(max(value(1), -40), +40);
   net.kernel = set(net.kernel, 'parameters', value(2:end));

elseif strcmp(property, 'x')

   net.x = value;

else

   net = {};

end

% bye bye...

