function value = getproperty(net, property)

% GETPROPERTY - get model properties 
%
%    value = getproperty(net, 'Property') returns the value of the specified
%    model property.

%
% File        : @klr/getproperty.m
%
% Date        : Friday 31st October 2003
%
% Author      : Dr Gavin C. Cawley
%
% Description : Accessor method used to retrieve model properties. 
%
% History     : 31/10/2003 - v1.00
%
% Copyright   : (c) Dr Gavin C. Cawley, October 2003.
%

if strcmp(property, 'alpha') 

   value = net.alpha;

elseif strcmp(property, 'criterion') 

   value = net.criterion;

elseif strcmp(property, 'lambda') 

   value = net.lambda;

elseif strcmp(property, 'kernel') 

   value = net.kernel;

elseif strcmp(property, 'parameters')

   value = [log(net.lambda)/log(2) ; getproperty(net.kernel, 'parameters')];

elseif strcmp(property, 'x') 

   value = net.x;

else

   value = getproperty(net.kernel, property);

end

% bye bye...

