function ker = setproperty(ker, property, value)

%
% SETPROPERTY - set individual kernel property
%
%    kernel = setproperty(kernel, 'property', value) sets the value of the
%    named kernel property for the specified kernel object.

%
% File        : @kernel/setproperty.m
%
% Date        : Friday 30th July 2004
%
% Author      : Dr Gavin C. Cawley
%
% Description : Mutator method used to set individual kernel properties. 
%
% History     : 30/07/2004 - v1.00
%
% Copyright   : (c) Dr Gavin C. Cawley, July 2004
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
%  

if nargin ~= 3

   error('wrong number of parameters');

elseif strcmp(property, 'type')

   ker.type = value;

else

   ker = {};

end

% bye bye...

