function K = gram(ker, x)

% GRAM - evaluate the Gram matrix
%
%    The Gram matrix, K, for data, x, and kernel, ker, is evaluated as
%    follows:
%
%       K = gram(ker, x)
%
%    Normally x is a (possible sparse) matrix of input patterns, such that
%    each column represents an attribute and each row represents an
%    observation.  Other viable options include a cell array or column vector
%    of structs or objects, allowing the use of kernel acting on structured
%    data or for instance variable length strings.

%
% File        : @kernel/gram.m
%
% Date        : Friday 30th July 2004
%
% Author      : Dr Gavin C. Cawley
%
% Description : Evaluate the Gram matrix for a given data set using a
%               specified kernel object.
%
% History     : 30/07/2004 - v1.00
%
% Copyright   : (c) Dr Gavin C. Cawley, July 2004
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
%

% evaluate the gram matrix

K = evaluate(ker, x, x);

% ensure the column is non-sparse

K = full(K);

% bye bye...

