function K = evaluate(ker, x, n)

% EVALUATE   Evaluate the Gram matrix
%
%    The Gram matrix for data sets X and x using kernel k is evaluated by
%
%       K = evaluate(ker, x1, x2)
%
%    Normally x1 and x2 are (possible sparse) matrices of input patterns, such
%    that each column represents an attribute and each row represents an
%    observation.  Other viable options include a cell array or column vector
%    of structs or objects, allowing the use of kernel acting on structured
%    data or for instance variable length strings.

%
% File        : @kernel/evaluate.m
%
% Date        : Friday 21st November 2002
%
% Author      : Dr Gavin C. Cawley
%
% Description : Evaluate the Gram matrix for a given data set using a
%               specified kernel object.
%
% History     : 21/11/2002 - v1.00
%
% Copyright   : (c) Dr Gavin C. Cawley, November 2002.
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
%

% bye bye...

