function selector = setproperty(selector, property, value)
%
% SETPROPERTY - set the value of a named property
%

%
% File        : @conjgrad/setproperty.m
%
% Date        : 
%
% Author      : Dr Gavin C. Cawley
%
% Description :
%
% History     : 
%
% Copyright   : (c) Dr Gavin C. Cawley, September 2015.
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
%

if strcmp(property, 'chi')

  selector.chi = value;; 

elseif strcmp(property, 'delta')

   selector.delta = value;

elseif strcmp(property, 'gamma')

   selector.gamma = value;

elseif strcmp(property, 'GradObj')

   selector.opts.GradObj = value;

elseif strcmp(property, 'MaxFunEvals')

   selector.opts.MaxFunEvals = value;

elseif strcmp(property, 'MaxIter')

   selector.opts.MaxIter = value;

elseif strcmp(property, 'rho')

   selector.rho = value;

elseif strcmp(property, 'sigma')

   selector.sigma = value;

elseif strcmp(property, 'TolFun')

   selector.opts.TolFun = value;

elseif strcmp(property, 'TolX')

   selector.opts.TolX = value;

else

   s = setproperty(selector.selector, property, value);

   if isempty(s) & iscell(s)

      selector = {};

   else

      selector.selector = s;

   end

end

% bye bye...

