function run_benchmark(benchmark, n)

fprintf(1, 'processing benchmark ''%s'' replicate %d...\n', benchmark, n);

% extend search path

addpath ../../data
addpath ../../matlab
addpath source

% create results directory

system(sprintf('mkdir -p %s/results', benchmark));

% load data

data = load('benchmarks', benchmark);

eval(sprintf('data=data.%s;', benchmark));

% get on with it

if exist(sprintf('%s/results/replicate_%03d.mat', benchmark, n)) == 0

   % load data

   data = load('benchmarks', benchmark);

   eval(sprintf('data=data.%s;', benchmark));

   % reset random number generators for reproducability

   rand('state', 0);
   randn('state', 0);

   % unpack data

   x_train = data.x(data.train(n,:),:);
   t_train = data.t(data.train(n,:),:);
   x_test  = data.x(data.test(n,:),:);
   t_test  = data.t(data.test(n,:),:);

   % train model

   t              = cputime;
   model          = train_model(x_train, t_train, benchmark, n);
   model.duration = cputime - t;

   % evaluate performance

   train_y           = generate_predictions(model, x_train);
   test_y            = generate_predictions(model, x_test);
   model.train_erate = mean((train_y >= 0) ~= (t_train >= 0));
   model.test_erate  = mean((test_y  >= 0) ~= (t_test  >= 0));
   [tp,fp]           = roc(t_train, train_y);
   model.train_auroc = auroc(tp, fp);
   [tp,fp]           = roc(t_test, test_y);
   model.test_auroc  = auroc(tp, fp);
   model.train_mse   = mean((train_y - t_train).^2);
   model.test_mse    = mean((test_y  - t_test ).^2);

   fprintf(1, '\n');
   fprintf(1, '%s : fold %d\n', benchmark, n);
   fprintf(1, '\n');
   fprintf(1, 'Training error = %f\n', model.train_erate);
   fprintf(1, '    Test error = %f\n', model.test_erate);
   fprintf(1, 'Training AUROC = %f\n', model.train_auroc);
   fprintf(1, '    Test AUROC = %f\n', model.test_auroc);
   fprintf(1, 'Training MSE   = %f\n', model.train_mse);
   fprintf(1, '    Test MSE   = %f\n', model.test_mse);
   fprintf(1, '         PRESS = %f\n', model.press);
   fprintf(1, '      Duration = %f\n', model.duration);
   fprintf(1, '\n');

   rand_state  = rand('state');
   randn_state = randn('state');

   save(sprintf('%s/results/replicate_%03d.mat', benchmark, n), ...
      'model', 'train_y', 'test_y');

end

% bye bye...

