%
% COLLATE.M 
%

% start from a clean slate

clear all

% extend search path

addpath ../../data
addpath ../../matlab
addpath source

% determine benchmarks

load benchmarks.mat benchmarks

for i=1:length(benchmarks)

   fprintf(1, '%15s ', benchmarks{i});  

   % load data

   data = load('benchmarks', benchmarks{i});

   eval(sprintf('data=data.%s;', benchmarks{i}));

   % get on with it

   if exist(sprintf('%s/results/results.mat', benchmarks{i})) == 0

      complete  = false(size(data.train,1),1);
      y_train   = zeros(size(data.train'));
      y_test    = zeros(size(data.test'));

      % get on with it!

      for j=1:size(data.train,1)

         if exist(sprintf('%s/results/replicate_%03d.mat', benchmarks{i}, j))

            complete(j) = 1;

            % load data for replicate j

            load(sprintf('%s/results/replicate_%03d.mat', benchmarks{i}, j));

            duration(j) = model.duration;

            % collate results

            y_train(:,j)  = train_y;
            y_test(:,j)   = test_y;
            err_train(j)  = model.train_erate;
            err_test(j)   = model.test_erate;
            auc_train(j)  = model.train_auroc;
            auc_test(j)   = model.test_auroc;
            mse_train(j)  = model.train_mse;
            mse_test(j)   = model.test_mse;
            press(j)      = model.press;

            fprintf(1, '% 3d%%\b\b\b\b', floor(100*mean(complete)));
   
         end

      end

   else

      load(sprintf('%s/results/results.mat', benchmarks{i}), 'y_train', ...
         'y_test', 'err_train', 'err_test', 'auc_train', 'auc_test', ...
         'mse_train', 'mse_test', 'press', 'duration');

      complete = true;

      fprintf(1, '100%%');

   end

   if all(complete)

      save(sprintf('%s/results/results.mat', benchmarks{i}), 'y_train', ...
         'y_test', 'err_train', 'err_test', 'auc_train', 'auc_test', ...
         'mse_train', 'mse_test', 'press', 'duration');

      % save summary

      fd = fopen(sprintf('%s/results/summary.txt', benchmarks{i}), 'w');

      fprintf(fd, '\n');
      str = sprintf('%s PERFORMANCE SUMMARY', upper(benchmarks{i}));
      fprintf(fd, '%s\n', str);
      str(:) = '=';
      fprintf(fd, '%s\n', str);
      fprintf(fd, '\n');
      fprintf(fd, 'Training error = %f (%f)\n', mean(err_train), ...
         std(err_train)/sqrt(length(err_train)));
      fprintf(fd, 'Training AUROC = %f (%f)\n', mean(auc_train), ...
         std(auc_train)/sqrt(length(auc_train)));
      fprintf(fd, 'Training MSE   = %f (%f)\n', mean(mse_train), ...
         std(mse_train)/sqrt(length(mse_train)));
      fprintf(fd, '    Test error = %f (%f)\n', mean(err_test), ...
         std(err_test)/sqrt(length(err_test)));
      fprintf(fd, '    Test AUROC = %f (%f)\n', mean(auc_test), ...
         std(auc_test)/sqrt(length(auc_test)));
      fprintf(fd, '    Test MSE   = %f (%f)\n', mean(mse_test), ...
         std(mse_test)/sqrt(length(mse_test)));
      fprintf(fd, '         PRESS = %f (%f)\n', mean(press), ...
         std(press)/sqrt(length(press)));
      fprintf(fd, '      Duration = %f (%f)\n', mean(duration), ...
         std(duration)/sqrt(length(duration)));
      fprintf(fd, '\n');

      fclose(fd);

   end

   fprintf(1, '\n');

   clear duration features err_train err_test y_train y_test auc_train auc_test mse_train mse_test press complete

end

% bye bye...

