function model = train_model(x_train, t_train, benchmark, n)

% get parameters of model with spherical RBF kernel

filename = sprintf('../experiment002/%s/results/replicate_%03d.mat', ... 
                   benchmark, n);
results  = load(filename, 'model');
lambda   = get(results.model.model, 'lambda');
eta      = get(results.model.model, 'eta');

% construct equivalent model with eliptical RBF model 

[ntp,d]     = size(x_train);
model.model = l2lssvm('lambda',    lambda,                      ...
                      'kernel',    rbf('eta', eta*ones(d,1)),   ...
                      'criterion', press);

% define model selection method (scaled conjugate gradient descent)

model.selector = conjgrad('estimator',   loo('criterion', press),   ...
                          'GradObj',     'on',                      ...
                          'TolFun',      1e-9,                      ...
                          'TolX',        1e-9,                      ...
                          'MaxIter',     1e+3,                      ...
                          'MaxFunEvals', 1e+3);

% perform model selection

[model.model,model.parameters,model.press] = select(model.selector,   ...
                                                    model.model,      ...
                                                    x_train,          ...
                                                    t_train);

% all done

