function model = train_model(x_train, t_train, benchmark, n)

% define model 

model.model = lssvm('lambda',    1,                   ...
                    'kernel',    rbf('eta', 0.125),   ...
                    'criterion', press);

% define model selection method (scaled conjugate gradient descent)

model.selector = conjgrad('estimator',   loo('criterion', press),   ...
                          'GradObj',     'on',                      ...
                          'TolFun',      1e-9,                      ...
                          'TolX',        1e-9,                      ...
                          'MaxIter',     1e+3,                      ...
                          'MaxFunEvals', 1e+3);

% perform model selection

[model.model,model.parameters,model.press] = select(model.selector,   ...
                                                    model.model,      ...
                                                    x_train,          ...
                                                    t_train);

% all done


