%%
%% This is file `ueaexam.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% ueaexam.dtx  (with options: `ueaexam.cls,package')
%% 
%%  ueaexam.dtx
%%  Copyright 2012 Nicola Talbot
%% 
%%  This work may be distributed and/or modified under the
%%  conditions of the LaTeX Project Public License, either version 1.3
%%  of this license of (at your option) any later version.
%%  The latest version of this license is in
%%    http://www.latex-project.org/lppl.txt
%%  and version 1.3 or later is part of all distributions of LaTeX
%%  version 2005/12/01 or later.
%% 
%%  This work has the LPPL maintenance status `maintained'.
%% 
%%  The Current Maintainer of this work is Nicola Talbot.
%% 
%%  This work consists of the files ueaexam.dtx and ueaexam.ins and the derived files ueaexam.cls, sample-exam-db.tex, sample-exam-diffmarks.tex, sample-exam-verb.tex, sample-exam.tex, sample-problems.tex, sample-code.java.
%% 
%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}
%% See ueaexam.dtx for documented source code.
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{ueaexam}[2012/01/22 v4.14 UEA exam class file (NLCT)]
\RequirePackage{probsoln}[2011/12/10]
\RequirePackage{etoolbox}
\newcommand*{\draftwatermark}{}
\newcommand*{\solutionswatermark}{}
\newcommand*{\setptsize}[1]{\def\@ptsize{#1}}
\setptsize{12}
\DeclareOption{10pt}{\setptsize{10}}
\DeclareOption{11pt}{\setptsize{11}}
\DeclareOption{12pt}{\setptsize{12}}
\DeclareOption{14pt}{\setptsize{14}}
\DeclareOption{17pt}{\setptsize{17}}
\DeclareOption{20pt}{\setptsize{20}}
\newcommand*{\setexampapersize}[1]{\def\@exam@paper@size{#1paper}}
\setexampapersize{a4}
\DeclareOption{a4paper}{\setexampapersize{a4}}
\DeclareOption{a3paper}{\setexampapersize{a3}}
\DeclareOption{oneside}{\@twosidefalse \@mparswitchfalse}
\DeclareOption{twoside}{\@twosidetrue  \@mparswitchfalse}
\newcommand*{\@@checktotal}{\@@checktotal@}
\DeclareOption{scorecheck}{\renewcommand*{\@@checktotal}{\@@checktotal@}}
\DeclareOption{noscorecheck}{\renewcommand*{\@@checktotal}{}}
\newcommand*{\WarnOrError}[2]{\ClassError{ueaexam}{#1}{#2}}
\DeclareOption{draft}%
{%
  \setlength\overfullrule{5pt}%
  \renewcommand*{\draftwatermark}{DRAFT}%
  \renewcommand*{\WarnOrError}[2]{\ClassWarning{ueaexam}{#1}}%
}
\DeclareOption{final}{%
  \setlength\overfullrule{0pt}%
  \renewcommand*{\draftwatermark}{}%
   \renewcommand*{\WarnOrError}[2]{\ClassError{ueaexam}{#1}{#2}}
}
\DeclareOption{leqno}{\input{leqno.clo}}
\DeclareOption{fleqn}{\input{fleqn.clo}}
\newif\ifnotesallowed
\notesallowedfalse
\DeclareOption{notesallowed}{\notesallowedtrue}
\DeclareOption{nonotesallowed}{\notesallowedfalse}
\newif\ifusetimes
\usetimestrue
\DeclareOption{times}{\usetimestrue}
\DeclareOption{notimes}{\usetimesfalse}
\def\ifsolutionsheet{\ifshowanswers}
\let\solutionsheetfalse\showanswersfalse
\let\solutionsheettrue\showanswerstrue
\ifcsundef{ueaexamhook}{}
{%
   \ueaexamhook
   \ifshowanswers
     \renewcommand*{\solutionswatermark}{SOLUTIONS}%
   \fi
}
\DeclareOption{solutions}%
{%
   \solutionsheettrue
   \renewcommand*{\solutionswatermark}{SOLUTIONS}%
}
\DeclareOption{nosolutions}%
{
  \solutionsheetfalse
   \renewcommand*{\solutionswatermark}{}%
}
\DeclareOption{watermarkfirst}{%
  \PassOptionsToPackage{firstpage}{draftwatermark}%
}
\ExecuteOptions{twoside,final}
\ProcessOptions
\input{size\@ptsize.clo}
\RequirePackage{draftwatermark}
\newcommand*{\exambackgroundtext}{}
\expandafter\ifstrempty\expandafter{\draftwatermark}%
{%
  \expandafter\ifstrempty\expandafter{\solutionswatermark}%
  {}%
  {%
    \renewcommand*{\exambackgroundtext}{\solutionswatermark}%
  }%
}%
{%
  \expandafter\ifstrempty\expandafter{\solutionswatermark}%
  {%
    \renewcommand*{\exambackgroundtext}{\draftwatermark}%
  }%
  {%
     \renewcommand*{\exambackgroundtext}{%
     \begin{tabular}{@{}c@{}}
     \draftwatermark\\
     \solutionswatermark
     \end{tabular}}%
  }%
}
\SetWatermarkText{\exambackgroundtext}
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}
\renewcommand\baselinestretch{}
\setlength\parskip{0\p@ \@plus \p@}
\@lowpenalty   51
\@medpenalty  151
\@highpenalty 301
\setcounter{topnumber}{2}
\renewcommand\topfraction{.7}
\setcounter{bottomnumber}{1}
\renewcommand\bottomfraction{.3}
\setcounter{totalnumber}{3}
\renewcommand\textfraction{.2}
\renewcommand\floatpagefraction{.5}
\setcounter{dbltopnumber}{2}
\renewcommand\dbltopfraction{.7}
\renewcommand\dblfloatpagefraction{.5}
\setlength  \labelsep  {.5em}
\setlength  \labelwidth{\leftmargini}
\addtolength\labelwidth{\labelsep}
\@beginparpenalty -\@lowpenalty
\@endparpenalty   -\@lowpenalty
\@itempenalty     -\@lowpenalty
\renewcommand\theenumi{\arabic{enumi}}
\renewcommand\theenumii{\alph{enumii}}
\renewcommand\theenumiii{\roman{enumiii}}
\renewcommand\theenumiv{\Alph{enumiv}}
\newcommand\labelenumi{\theenumi.}
\newcommand\labelenumii{(\theenumii)}
\newcommand\labelenumiv{\theenumiv.}
\renewcommand\p@enumii{\theenumi}
\renewcommand\p@enumiii{\theenumi(\theenumii)}
\renewcommand\p@enumiv{\p@enumiii\theenumiii}
\newcommand\labelitemi{$\m@th\bullet$}
\newcommand\labelitemii{\normalfont\bfseries --}
\newcommand\labelitemiii{$\m@th\ast$}
\newcommand\labelitemiv{$\m@th\cdot$}

\newcommand{\setpenum}[2]{%
  \expandafter\def\csname p@enum\romannumeral#1\endcsname{#2}%
}

\setlength\leftmargini  {2.5em}
\setlength\leftmarginii  {2.2em}
\setlength\leftmarginiii {1.87em}
\setlength\leftmarginiv  {1.7em}
\setlength\leftmarginv  {1em}
\setlength\leftmarginvi {1em}
\setlength\leftmargin    {\leftmargini}
\newenvironment{description}
               {\list{}{\labelwidth\z@ \itemindent-\leftmargin
                        \let\makelabel\descriptionlabel}}
               {\endlist}
\newcommand\descriptionlabel[1]{\hspace\labelsep
                                \normalfont\bfseries #1}
\newenvironment{verse}
               {\let\\=\@centercr
                \list{}{\itemsep      \z@
                        \itemindent   -1.5em%
                        \listparindent\itemindent
                        \rightmargin  \leftmargin
                        \advance\leftmargin 1.5em}%
                \item[]}
               {\endlist}
\newenvironment{quotation}
               {\list{}{\listparindent 1.5em%
                        \itemindent    \listparindent
                        \rightmargin   \leftmargin
                        \parsep        \z@ \@plus\p@}%
                \item[]}
               {\endlist}
\newenvironment{quote}
               {\list{}{\rightmargin\leftmargin}%
                \item[]}
               {\endlist}
\setlength\arraycolsep{5\p@}
\setlength\tabcolsep{6\p@}
\setlength\arrayrulewidth{.4\p@}
\setlength\doublerulesep{2\p@}
\setlength\tabbingsep{\labelsep}
\skip\@mpfootins = \skip\footins
\setlength\fboxsep{3\p@}
\setlength\fboxrule{.4\p@}
\renewcommand\theequation{\arabic{equation}}
\newcounter{figure}
\renewcommand\thefigure{\@arabic\c@figure}
\def\fps@figure{htbp}
\def\ftype@figure{1}
\def\ext@figure{lof}
\def\fnum@figure{\figurename~\thefigure}
\newcounter{solutionfigure}
\renewcommand\thesolutionfigure{\@Alph\c@solutionfigure}
\def\fps@solutionfigure{htbp}
\def\ftype@solutionfigure{3}
\def\ext@solutionfigure{lof}
\def\fnum@solutionfigure{\figurename~\thesolutionfigure}
\newenvironment{figure}
               {%
                \setlength\abovecaptionskip{\captionskip}%
                \setlength\belowcaptionskip{0pt}%
                \ifinsolution
                  \def\begfig@env{\solutionfont\@float{solutionfigure}}%
                \else
                  \def\begfig@env{\@float{figure}}%
                \fi
               \begfig@env
               }
               {\end@float}
\newenvironment{figure*}
               {%
                \setlength\abovecaptionskip{\captionskip}%
                \setlength\belowcaptionskip{0pt}%
                \ifinsolution
                  \def\begfig@env{\solutionfont\@dblfloat{solutionfigure}}%
                \else
                  \def\begfig@env{\@dblfloat{figure}}%
                \fi
               \begfig@env
               }
               {\end@dblfloat}
\newcounter{table}
\renewcommand\thetable{\@arabic\c@table}
\def\fps@table{htbp}
\def\ftype@table{2}
\def\ext@table{lot}
\def\fnum@table{\tablename~\thetable}
\newcounter{solutiontable}
\renewcommand\thesolutiontable{\@Alph\c@solutiontable}
\def\fps@solutiontable{htbp}
\def\ftype@solutiontable{4}
\def\ext@solutiontable{lot}
\def\fnum@solutiontable{\tablename~\thesolutiontable}
\newenvironment{table}
               {%
               \setlength\abovecaptionskip{0pt}%
               \setlength\belowcaptionskip{\captionskip}%
                \ifinsolution
                  \def\begtab@env{\solutionfont\@float{solutiontable}}%
                \else
                  \def\begtab@env{\@float{table}}%
                \fi
               \begtab@env
               }
               {\end@float}
\newenvironment{table*}
               {%
               \setlength\abovecaptionskip{0pt}%
               \setlength\belowcaptionskip{\captionskip}%
                \ifinsolution
                  \def\begtab@env{\solutionfont\@dblfloat{solutiontable}}%
                \else
                  \def\begtab@env{\@dblfloat{table}}%
                \fi
                \begtab@env
                }
               {\end@dblfloat}
\newcommand\figurename{Figure}
\newcommand\tablename{Table}
\newlength\abovecaptionskip
\newlength\belowcaptionskip
\newlength\captionskip
\setlength\captionskip{10pt}
\def\cal{\protect\pcal}
\newcommand{\pcal}{\@fontswitch{\relax}{\mathcal}}
\def\mit{\protect\pmit}
\newcommand{\pmit}{\@fontswitch{\relax}{\mathnormal}}
\newcommand\@pnumwidth{1.55em}
\renewcommand\footnoterule{%
  \kern-3\p@
  \hrule width .4\columnwidth
  \kern 2.6\p@}
\long\def\@makefntext#1{%
    \parindent 1em%
    \noindent
    \hbox to 1.8em{\hss\@makefnmark}#1}
\setlength\columnsep{10\p@}
\setlength\columnseprule{0\p@}
\pagenumbering{arabic}      % Arabic page numbers
\if@twoside
\else
  \raggedbottom
\fi
\expandafter\RequirePackage\expandafter[\@exam@paper@size,%
   left=0.75in,right=0.9in,%
   top=1in,bottom=1in,%
   marginparwidth=0.7in,%
   includemp]{geometry}
\RequirePackage{ifthen}
\RequirePackage{calc}
\RequirePackage{enumerate}
\RequirePackage{paralist}
\RequirePackage{fp}
\RequirePackage{amsmath}
\ifusetimes
  \RequirePackage{lmodern}
  \RequirePackage{mathptmx}
  \RequirePackage{helvet}
  \RequirePackage{courier}
\fi
\renewcommand\familydefault{\sfdefault}
\RequirePackage{fmtcount}
\linespread{1.6}
\newcommand{\@makecaption}[2]{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{#1\aftercaptionnumber #2}%
  \ifdim \wd\@tempboxa >\hsize
    #1\aftercaptionnumber#2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}
\newcommand*{\aftercaptionnumber}{.\space}
\newcommand{\labelenumiii}{(\theenumiii)}
\newcommand*{\resetpardim}{%
  \setlength{\parindent}{1.5em}%
  \setlength{\parskip}{0.0pt plus 1.0pt}%
  \renewcommand*{\baselinestretch}{1}%
}
\newcommand*{\UEAExamFragileExt}{ueatmp}
\newwrite\ueaexam@write
\newif\ifinsolution
\insolutionfalse
\newcommand*{\Solution}{\@ifstar\s@Solution\@Solution}
\newcommand{\s@Solution}[1]{%
   \begin{onlysolution}%
   \begin{solution}%
   \insolutiontrue
   \resetpardim
   \solutionfont
   #1%
   \end{solution}%
   \end{onlysolution}
}
\def\@Solution{%
  \begingroup
    \@prob@fragiletrue
    \obeylines\obeyspaces
    \@makeother\#
    \@makeother\%
    \@Solution@
}
\long\def\@Solution@#1{%
  \probsoln@process@fragile{#1}%
  \immediate\openout\ueaexam@write=\ProbSolnFragileFile.\UEAExamFragileExt
  \immediate\write\ueaexam@write{%
      \string\begin{solution}\string\insolutiontrue
      \string\resetpardim
      \string\solutionfont\space
      \@prob@tmp@problem^^J
      \string\end{solution}\string\relax
    }%
   \immediate\closeout\ueaexam@write
   \ifsolutionsheet
     \gdef\do@solution{%
        \InputIfFileExists{\ProbSolnFragileFile.\UEAExamFragileExt}{}%
          {\ClassWarning{ueaexam}{Can't read \ProbSolnFragileFile.\UEAExamFragileExt}}%
     }%
   \else
     \global\let\do@solution\relax
   \fi
  \endgroup
  \do@solution
}
\@prob@fragiletrue
\newcommand*{\solutionfont}{\sffamily\slshape}
\renewcommand{\@ns@newproblem}[4][]{%
  \begin{defproblem}[\@newprob@argN][#1]{#2}%
    #3\Solution{#4}%
  \end{defproblem}%
}
\newif\ifturnover
\turnovertrue
\newcommand*{\turnovertext}{TURN OVER}
\newcommand*{\copyrighttext}{Copyright of the \@university}
\newcommand*{\sectionname}{section}
\def\ps@ueaexam{%
\def\@oddhead{\hfil Page \thepage\hfil}
\def\@evenhead{\hfil Page \thepage\hfil}
\def\@oddfoot{\@ccode\hfill Version \@version\rlap{\quad\ifturnover \textbf{\turnovertext}\fi}}
\def\@evenfoot{\@ccode\hfill Version \@version}}
\def\ps@ueaexamtitle{%
\def\@oddhead{}
\def\@evenhead{\@oddhead}
\def\@oddfoot{\def\arraystretch{0.75}%
  \begin{tabular}[b]{@{}l}%
    \@ccode\\\copyrighttext
  \end{tabular}\hfill
  \begin{tabular}[b]{r@{}}%
    Module Contact: \@contact\\Version \@version
  \end{tabular}}
\def\@evenfoot{\@oddfoot}
}
\newcommand*{\version}[1]{\renewcommand*{\@version}{#1}}
\newcommand*{\@version}{??\protect\WarnOrError{Exam version missing}{You need to
  use \string\version\space to specify the version number}}
\newcommand*{\contact}[1]{\renewcommand*{\@contact}{#1}}
\newcommand*{\@contact}{??\protect\WarnOrError{Contact missing}{You
need to use \string\contact\space to specify the contact person}}
\def\@ccode{}
\newcommand{\@cname}{}
\newcommand{\course}[2]{%
  \renewcommand{\@ccode}{#1}\renewcommand{\@cname}{#2}}
\def\@sitcode{}
\newcommand{\sitting}[1]{\renewcommand{\@sitcode}{#1}}   %mod 06
\newcommand{\@university}{University of East Anglia}
\newcommand{\@University}{UNIVERSITY OF EAST ANGLIA}
\newcommand{\university}[1]{\renewcommand{\@university}{#1}
\renewcommand{\@University}{\uppercase{#1}}}
\newcommand{\@school}{School of Computing Sciences}
\newcommand{\school}[1]{\renewcommand{\@school}{#1}}
\@onlypreamble{\school}
\newcommand*{\semester}[1]{%
  \ClassError{ueaexam}{\string\semester\space is obsolete. Please
   use \string\sitting\space instead.}{}%
}
\newcount\ueaexam@tmpct
\def\@examyear{%
  \ueaexam@tmpct=\year
  \ifnum\month>7\relax
    \advance\ueaexam@tmpct by 1\relax
    \the\year\examyearsep\expandafter\@gobbletwo\number\the\ueaexam@tmpct
  \else
    \advance\ueaexam@tmpct by -1\relax
    \edef\nextyear{\number\the\year}%
    \the\ueaexam@tmpct\examyearsep\expandafter\@gobbletwo\number\year
  \fi
}
\newcommand*{\examyearsep}{-}
\newcommand{\examyear}[1]{\renewcommand{\@examyear}{#1}}
\newcommand{\@timeallowed}{%
  ??\ClassWarning{ueaexam}{No time limit specified}%
}
\newcommand{\timeallowed}[1]{\renewcommand{\@timeallowed}{#1}}
\def\@rubric{%
  \ifdef{\@ansrub}{\@ansrub\par}{}%
}
\newcommand{\rubric}[1]{\appenditem#1\to\@rubric}
\newcommand*{\questiontotal}[1]{\def\@questiontotal{#1}}
\newcommand*{\gquestiontotal}[1]{\gdef\@questiontotal{#1}}
\newcommand*{\@questiontotal}{15}
\def\@runningtotal{-1}
\newcommand*{\@@checktotal@}{%
  \FPifeq{\@runningtotal}{\@questiontotal}%
    \relax
  \else
    \FPclip\@runningtotal\@runningtotal
    \WarnOrError{Scores for question \theenumi\space don't add
         up to \@questiontotal.^^J(Score total = \@runningtotal.)}%
         {Each exam question must have a total score of \@questiontotal.}%
  \fi
}
\let\@checktotal\relax
\let\@uea@org@item\@item
\newcommand{\question@item}{%
  \ifthenelse{\@enumdepth=1 \AND \equal{\@currenvir}{enumerate}}%
  {%
    \@checktotal
    \gdef\@runningtotal{0}%
    \global\let\@checktotal\@@checktotal
  }{}%
  \@uea@org@item
}
\let\@item\question@item
\let\@org@endenumerate\endenumerate
\def\endenumerate{%
  \ifnum\@enumdepth=1\relax
    \@checktotal
    \global\let\@checktotal\relax
  \fi
  \@org@endenumerate
}
\newcommand{\score}[1]{%
  \@for\@thisscore:=#1\do{%
    \FPadd{\@runningtotal}{\@runningtotal}{\@thisscore}%
  }%
  \global\let\@runningtotal\@runningtotal
  \scoreformat{#1}%
}
\newcommand{\scoreformat}[1]{\marginpar{[\marklabel{#1}]}}
\newcommand*{\marklabel}[1]{%
  #1~\ifthenelse{\equal{#1}{1}}{mark}{marks}%
}
\settowidth{\marginparwidth}{[\marklabel{88}]}
\newtoks\uea@toks
\long\def\appenditem#1\to#2{%
  \uea@toks={#1}%
  \toks@=\expandafter{#2}%
  \protected@xdef#2{\the\toks@\the\uea@toks}%
}
\long\def\prependitem#1\to#2{%
  \uea@toks={#1}%
  \toks@=\expandafter{#2}%
  \protected@xdef#2{\the\uea@toks\the\toks@}%
}
\def\addtorubric#1{%
  \@ifundefined{@ansrub}%
  {%
    \ClassError{ueaexam}{Can't add to rubric: no rubric defined yet}{}%
  }%
  {%
    \protected@edef\@ansbl{#1}%
    \expandafter\appenditem\@ansbl\to\@ansrub
  }%
}
\newcounter{section}
\renewcommand{\thesection}{\Alph{section}}
\newcommand*{\ansrubsep}{\space and\space}
\newif\ifisnumchecked
\newcommand{\@ifisnum}[3]{%
  \ifblank{#1}%
  {#3}%
  {%
    \isnumcheckedtrue
    \@if@isnum#1\@nnil
    \ifisnumchecked #2\else#3\fi
  }%
}
\def\@if@isnum#1#2{%
  \ifthenelse{\equal{#1}{0}\OR
              \equal{#1}{1}\OR
              \equal{#1}{2}\OR
      \equal{#1}{3}\OR
              \equal{#1}{4}\OR
              \equal{#1}{5}\OR
              \equal{#1}{6}\OR
              \equal{#1}{7}\OR
              \equal{#1}{8}\OR
              \equal{#1}{9}}%
  {%
    \ifx#2\@nnil
      \let\next\@gobble
    \else
      \let\next\@if@isnum
    \fi
  }%
  {%
    \isnumcheckedfalse
    \let\next\@if@isnumgobble
  }%
  \next#2
}
\def\@if@isnumgobble#1\@nnil{}
\newcommand{\section}[2][\relax]{%
  \clearpage
  \def\@sectmarg{#2}%
  \def\@sectoarg{#1}%
  \ifthenelse{\equal{#2}{the}\OR\equal{#2}{all}}
  {%
    \ifthenelse{\equal{#2}{the}}{\def\@question{question}}{\def\@question{questions}}%
    \edef\@sectmarg{Answer \uppercase{#2} \@question\space from this Section.}%
    \ifx#1\relax
      \edef\@sectoarg{\uppercase{#2} \@question}%
    \fi
  }%
  {%
    \@ifisnum{#2}%
    {%
      \@numberstringM{#2}{\@num}%
       \ifnum#2=1\relax
        \def\@question{question}%
       \else
        \def\@question{questions}%
       \fi
       \edef\@sectmarg{Answer \uppercase{\@num} \@question\space from this Section.}%
      \ifx#1\relax
       \edef\@sectoarg{\uppercase{\@num} \@question}%
      \fi
    }%
    {}%
  }%
  \refstepcounter{section}%
  {%
    \par
    \centering
    \hspace*{-\@enumdepth\leftmargin}%
    \begin{tabular}{@{}c@{}}\Large SECTION~\thesection\\\@sectmarg\end{tabular}%
    \par
  }%
  \expandafter\ifx\@sectoarg\relax
    \relax
  \else
    \expandafter\ifx\@ansrub\relax
      \xdef\@ansrub{\@sectoarg\space from Section \thesection}%
    \else
      \def\ansrubsep{,\space}%
      \toks@{\ansrubsep}%
      \xdef\@ansrub{\@ansrub \the\toks@ \@sectoarg\space from Section \thesection}%
    \fi
  \fi
}
\newcommand{\maketitle}{%
  \begingroup
    \expandafter\ifx\csname @ansrub\endcsname\relax
      \gdef\@oldansrub{\relax}
    \else
      \global\let\@oldansrub\@ansrub
    \fi
    \thispagestyle{ueaexamtitle}%
    \hfill\vspace{1.5cm}%
    \begin{tabular}{r}
      \bfseries\@University\\
      \@school\\
      \@sitcode\space Examination \@examyear  %mod06
    \end{tabular}%
    \par
    \setlength{\parindent}{0pt}%
    \setlength{\parskip}{\@ptsize pt plus 1pt minus 1pt}%
    \textbf{\MakeUppercase\@cname}\\[5pt]%
    \@ccode\\[24pt]%
    Time allowed: \@timeallowed\par
    \@rubric
    \par
    \vfill
    {%
      \bfseries\normalsize
      \ifnotesallowed \strut\else Notes are not permitted in this examination.\fi\par
      Do not turn over until you are told to do so by the Invigilator.%
    }%
    \hfill\par
    \vspace*{0.5in}
  \endgroup
  \newpage
  \gdef\@ansrub{\relax}%
  \pagestyle{ueaexam}%
}
\AtEndDocument{%
  \@ifundefined{@ansrub}
  {%
    \ClassError{ueaexam}{No rubric defined. Have you remembered to
      use \string\maketitle?}{}%
  }%
  {%
    \expandafter\ifx\@ansrub\relax
      \relax
    \else
      \prependitem{Answer }\to\@ansrub
      \appenditem.\to\@ansrub
      \protected@write\@auxout{}{\string\gdef\string\@ansrub{\@ansrub}}%
    \fi
    \ifthenelse{\equal{\@oldansrub}{\@ansrub}}%
    {}%
    {%
      \ClassWarning{ueaexam}{Title page needs updating.
        Rerun to get it right.}%
    }%
  }%
  \turnoverfalse
  \par\hfil\EndOfPaper\hfil
}
\newcommand*{\EndOfPaper}{\large\bfseries END OF PAPER}

\endinput
%%
%% End of file `ueaexam.cls'.
