function value = getproperty(net, property)
%
% GETPROPERTY - retrieve a named property of an optimised GKM
%
%    VALUE = GETPROPERTY(NET,'PROPERTY') returns the value of the named
%    PROPERTY of an object implementing an optimsied GKM. 

%
% File        : @optimsied/getproperty.m
%
% Date        : Friday 24th August 2007
%
% Author      : Dr Gavin C. Cawley
%
% Description : Retrieve a named property of an optimised GKM object.
%
% History     : 24/08/2007 - v1.00
%
% Copyright   : (c) Dr Gavin C. Cawley, August 2007.
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
%

if strcmp(property, 'gkm')

   value = net.gkm;

elseif strcmp(property, 'selector')

   value = net.selector;

else

   value = getproperty(net.gkm);

   if isempty(value) & iscell(value)

      value = getproperty(net.selector);

   end

end

% bye bye...

