function [model, p, L] = select(s, model, x, t, varargin)
%
% SELECT - perform model selection via a simple grid-search  procedure
%
%    MODEL = SELECT(GRIDSEARCH,MODEL,X,Y) optimises the hyper-parameters of a
%    generalised kernel machine, MODEL, using a simple grid-based search
%    procedure.

%
% File        : @gridsearch/gridsearch.m
%
% Date        : Sunday 26th August 2007
%
% Author      : Dr Gavin C. Cawley
%
% Description : Select the optimal hyper-parameters for a generalised kernel
%               machine optimisation of a model selection criterion using the
%               basic grid-search procedure [1].
%
% History     : 26/08/2007 - v1.00
%
% Copyright   : (c) Dr Gavin C. Cawley, August 2007.
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
%

estimator = get(s, 'estimator'); 
n         = length(get(model, 'parameters'));

if size(s.min, 1) ~= n

   if size(s.min, 1) == 1

      s.min  = s.min*ones(n, 1);
      s.max  = s.max*ones(n, 1);
      s.step = s.step*ones(n, 1);

   else

      error('grid search dimensions incompatible with parameter vector');

   end

end

% perform recursive grid-based search

p         = generate(s);
cost      = realmax;
best      = [];

for i=1:size(p,1)

   model = set(model, 'parameters', p(i,:));

   newcost = estimate(estimator, model, x, t, varargin{:});

   if newcost < cost

      cost = newcost;
      best = i;

   end

   fprintf(1, ...
           'trials = %d/%d : cost = %f : best = %f\n', ...
            i, ...
            size(p,1), ...
            newcost, ...
            cost);

   L(i) = newcost;

end

[foo, idx] = min(L);
model      = train(set(model, 'parameters', p(idx,:)), x, t, varargin{:});
L          = L(:);

% bye bye...

