function net = kpor(varargin)

% KPOR - kernel Poisson regression machine

%
% File        : @kpor/kpor.m
%
% Date        : Wednesday 8th August 2007
%
% Author      : Dr Gavin C. Cawley
%
% Description : Constructor for a kernel Poisson regression
%               machine.
%
% References  :
%
% History     : 8/8/2007 - v1.00
%
% Copyright   : (c) Dr Gavin C. Cawley, August 2007.
%
%    This program is free software; you can redistribute it and/or modify
%    it under the terms of the GNU General Public License as published by
%    the Free Software Foundation; either version 2 of the License, or
%    (at your option) any later version.
%
%    This program is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%    GNU General Public License for more details.
%
%    You should have received a copy of the GNU General Public License
%    along with this program; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
%

if nargin == 0

   net = struct([]);
   net = class(net, 'kpor', gkm);
   net = set(net, 'acronym',    'kpor', ...
                  'name',       'kernel Poisson regression', ...
                  'invlink',    inline('exp(eta)', 'eta'), ...
                  'loss',       inline('-(y.*eta - exp(eta))', 'y', 'eta'), ...
                  'W',          inline('exp(eta)', 'eta'), ...
                  'canonical',  'exp(eta)');

else

   net = set(kpor, varargin{:});
   
end

% bye bye...

